*Generate additional variables for the analysis

global place1 ...\EU-SILC\Cross\2020-04\
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK


*Active age and active labour market participation

foreach ctry of global countries {
	di "`ctry'"
	forvalues year=2009(1)2010 {
		di "`ctry': `year'"

		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
			use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
			
			cap drop actage
			gen actage = ((year-rb080)>=18 & (year-rb080)<65)
			
			cap drop active
			
			if `year'<2009 gen active = (pl030<3)
			else gen active = (pl031<5)
		
			cap sum ok if year==`year' & actage==1 & (pl040==1 | pl040==2)
			if _rc==0 local val = r(mean)
			else local val=.

			keep country year hid pid actage active
			compress
			save "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta", replace
		}

	}
}


*Age, equivalent disposable income and poverty status
******************************************************


cap mat drop thresholds
cap mat drop poors
foreach ctry of global countries {
	di "`ctry'"
	cap mat drop tempthresh
	cap mat drop temppoors
	local years
	forvalues year=2004(1)2018 {
		local years `years' `year'
		di "`year'", _continue
		
		local v1=.
		local v2=.
		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
			use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
	
			cap drop age
			cap drop hydisp
			cap drop child14
			cap drop adult14
			cap drop hhnbr_child14
			cap drop hhnbr_adult14
			cap drop hhnbr_pers
			cap drop eqs
			cap drop sum080
			cap drop hystd
			cap drop thresh60
			cap drop arop60

			quietly {
				gen int age = rx020
				replace age = year-rb080 - 1 if rx020==.

				/*total disposable hh income * within hh non-response inflation factor*/ 

				*Since EU-SILC 2009, it is practice to include the sum of pensions received from individual private plans (other than
				*those covered under ESSPROS) (PY080G) into equivalent disposable income (HX090). However, for reasons of consistency over time: choose whether to include it or not
				*From EU-SILC 2011 onwards, PY080G is automatically included in the computation of HY020, so it is preferable to add it everywhere to make data comparable.


				* 'old' style:
				*gen hydisp=hy020*hy025 

				* 'new' style:
				cap gen hy025=1
				if `year'<2011 {
					bysort country hid: egen sum080=sum(py080g)
					gen hydisp=(hy020+sum080)*hy025
				}
				else gen hydisp=hy020*hy025

				gen byte child14=.
				replace child14=1 if age<14
				replace child14=0 if age>=14

				gen byte adult14=.
				replace adult14=1 if age>=14
				replace adult14=0 if age<14

				bysort country hid: egen hhnbr_child14 = sum(child14)
				bysort country hid: egen hhnbr_adult14 = sum(adult14)
				gen hhnbr_pers = hhnbr_child14 + hhnbr_adult14

				gen float eqs=.
				replace eqs= 1+(hhnbr_adult14 -1)*0.5 + hhnbr_child14 * 0.3 if hhnbr_adult14>=1
				replace eqs= 1+(hhnbr_child14 -1)* 0.3 if hhnbr_adult14<1

				gen hystd=hydisp/eqs

				gen thresh60=.
				qui: sum hystd [aw=rb050] if country=="`ctry'", de
				local v1 = 0.6*r(p50)
				replace thresh60=`v1' if country=="`ctry'"
				
				gen arop60=.
				replace arop60=1 if hystd<thresh60
				replace arop60=0 if hystd>=thresh60 & hystd!=.
				
				qui: sum arop60 [aw=rb050] if country=="`ctry'"
				local v2 = r(mean)
				
				keep country year hid pid age hydisp eqs hystd thresh60 arop60
				compress
				merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
				cap drop _merge
				save "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta", replace
			}
		}
		mat def tempthresh = nullmat(tempthresh), `v1'
		mat def temppoors = nullmat(temppoors), `v2'
	}
	mat def thresholds = nullmat(thresholds) \ tempthresh
	mat def poors = nullmat(poors) \ temppoors
}

mat rownames thresholds = ${countries}
mat colnames thresholds = 2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 
mat rownames poors = ${countries}
mat colnames poors = 2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 

mat li thresholds
mat li poors

*Additional check

cap mat drop thresholds
cap mat drop poors
foreach ctry of global countries {
	di "`ctry'"
	cap mat drop tempthresh
	cap mat drop temppoors
	local years
	forvalues year=2004(1)2018 {
		local years `years' `year'
		di "`year'", _continue
		
		local v1=.
		local v2=.
		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
			quietly {
				use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
				merge 1:1 hid pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta", keepusing(arop60)
				
				gen test = (hx080!=arop60)
				
				sum test [aw=rb050]
				local v1=r(mean)
			}
		}
		mat def temppoors = nullmat(temppoors), `v1'
		
	}
	mat def poors = nullmat(poors) \ temppoors
}
		
mat rownames poors = ${countries}
mat colnames poors = 2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 
mat li poors

***Income including production for own consumption (HY170N)
***********************************************************

global countries PL RO

cap mat drop thresholds
cap mat drop poors
foreach ctry of global countries {
	di "`ctry'"
	cap mat drop tempthresh
	cap mat drop temppoors
	local years
	forvalues year=2018(1)2018 {
		local years `years' `year'
		di "`year'", _continue
		
		local v1=.
		local v2=.
		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
			use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
	
			cap drop age
			cap drop hydisp
			cap drop child14
			cap drop adult14
			cap drop hhnbr_child14
			cap drop hhnbr_adult14
			cap drop hhnbr_pers
			cap drop eqs
			cap drop sum080
			cap drop hystd
			cap drop thresh60
			cap drop arop60

			quietly {
				gen int age = rx020
				replace age = year-rb080 - 1 if rx020==.

				/*total disposable hh income * within hh non-response inflation factor*/ 

				*Since EU-SILC 2009, it is practice to include the sum of pensions received from individual private plans (other than
				*those covered under ESSPROS) (PY080G) into equivalent disposable income (HX090). However, for reasons of consistency over time: choose whether to include it or not
				*From EU-SILC 2011 onwards, PY080G is automatically included in the computation of HY020, so it is preferable to add it everywhere to make data comparable.


				* 'old' style:
				*gen hydisp=hy020*hy025 

				* 'new' style:
				cap gen hy025=1
				gen hydisp1=(hy020+hy170n)*hy025

				gen byte child14=.
				replace child14=1 if age<14
				replace child14=0 if age>=14

				gen byte adult14=.
				replace adult14=1 if age>=14
				replace adult14=0 if age<14

				bysort country hid: egen hhnbr_child14 = sum(child14)
				bysort country hid: egen hhnbr_adult14 = sum(adult14)
				gen hhnbr_pers = hhnbr_child14 + hhnbr_adult14

				gen float eqs=.
				replace eqs= 1+(hhnbr_adult14 -1)*0.5 + hhnbr_child14 * 0.3 if hhnbr_adult14>=1
				replace eqs= 1+(hhnbr_child14 -1)* 0.3 if hhnbr_adult14<1

				gen hystd1=hydisp1/eqs

				gen thresh601=.
				qui: sum hystd1 [aw=rb050] if country=="`ctry'", de
				local v1 = 0.6*r(p50)
				replace thresh601=`v1' if country=="`ctry'"
				
				gen arop601=.
				replace arop601=1 if hystd1<thresh601
				replace arop601=0 if hystd1>=thresh601 & hystd!=.
				
				qui: sum arop601 [aw=rb050] if country=="`ctry'"
				local v2 = r(mean)
				
				keep country year hid pid age hydisp eqs hystd thresh60 arop60
				compress
				merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
				cap drop _merge
				save "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta", replace
			}
		}
		mat def tempthresh = nullmat(tempthresh), `v1'
		mat def temppoors = nullmat(temppoors), `v2'
	}
	mat def thresholds = nullmat(thresholds) \ tempthresh
	mat def poors = nullmat(poors) \ temppoors
}

mat rownames thresholds = ${countries}
mat colnames thresholds = 2018 
mat rownames poors = ${countries}
mat colnames poors = 2018 

mat li thresholds
mat li poors


***Earnings***
**************


foreach ctry of global countries {
	di "`ctry'"
	forvalues year=2004(1)2018 {
		di "`ctry': `year'"

		cap confirm file "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta"
		
		if _rc==0 {
			use "${place1}\`ctry'\\`year'\c`ctry'`year'_all.dta", clear
			
			merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
			
			sum py020g [iw=pb040] if active==1 & actage==1 & py020g>0 & py020g!=. // with exception of AT, all countries have values
			local top = r(p99)
			cap drop compcar
			gen compcar = py020g
			replace compcar = `top' if py020g>`top' & py020g!=.
			replace compcar = 0 if py020g<0 | py020g==. | country=="AT" | country=="FR"
			
			
			cap drop earns1 
			gen earns1 = py010g + py050g
			replace earns1 = 0 if earns1<0
			cap _pctile earns1 [pw=pb040] if actage==1 & active==1 & earns1!=0, p(50 99.9)
			local med=r(r1)
			local top=r(r2)
			replace earns1 = `top' if earns1>`top' & earns1!=.
			replace earns1 = earns1 / `med'
			
			cap drop earns2 
			gen earns2 = py010g + compcar + py050g
			replace earns2 = 0 if earns2<0
			cap _pctile earns2 [pw=pb040] if actage==1 & active==1 & earns2!=0, p(50 99.9)
			local med=r(r1)
			local top=r(r2)
			replace earns2 = `top' if earns2>`top' & earns2!=.
			replace earns2 = earns2 / `med'
			
			sum earns1 earns2 [aw=pb040] if active==1 & actage==1 & earns1!=0, de
			
			keep country year hid pid earns1 earns2
			compress
			
			merge 1:1 country year pid using "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta"
			cap drop _merge
			save "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars.dta", replace
		}

	}
}
